/*------------------------------------------------------------------------------*
 * File Name: PickPeak.h	 													*
 * Creation: 																	*
 * Purpose: OriginC Header H file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _PICK_PEAK_H__
#define _PICK_PEAK_H__

enum
{
	PEAK_PICK_BRANCH_ID_BASELINE				= 1,
	PEAK_PICK_BRANCH_ID_FIND_PEAK,
	PEAK_PICK_BRANCH_ID_ROI_BOX,
	
	PEAK_PICK_BRANCH_ID_EXISTING_DATASET,
	PEAK_PICK_BRANCH_ID_DATASET_RANGE1,

	PEAK_PICK_BRANCH_ID_REFERENCE_DATA,
	PEAK_PICK_BRANCH_ID_DATA_RANGE1,

	//PEAK_PICK_BRANCH_ID_DIRECTION,
	PEAK_PICK_BRANCH_ID_PEAK_FINDING_SETTINGS,
	PEAK_PICK_BRANCH_ID_DERIV_SMOOTH,
	PEAK_PICK_BRANCH_ID_PEAK_FILTERING,
	PEAK_PICK_BRANCH_ID_PEAK_LABELS,
	PEAK_PICK_BRANCH_ID_RESULT,
	PEAK_PICK_BRANCH_ID_XSCALE,
};

enum
{
	PEAK_PICK_VAR_ID_BASELINE_MODE		= DATAID_USER_BASE,
	//PEAK_PICK_VAR_ID_EXISTING_DATASET,
	PEAK_PICK_VAR_ID_DATASET_X,
	PEAK_PICK_VAR_ID_DATASET_Y,
	PEAK_PICK_VAR_ID_DATASET_ED,
	PEAK_PICK_VAR_ID_BASELINE_CONST,
	PEAK_PICK_VAR_ID_BASELINE_CREATION,
	//PEAK_PICK_VAR_ID_REFERENCE_DATA,
	PEAK_PICK_VAR_ID_DATA_X,
	PEAK_PICK_VAR_ID_DATA_Y,
	PEAK_PICK_VAR_ID_DATA_ED,
	PEAK_PICK_VAR_ID_Y_BASE,
	PEAK_PICK_VAR_ID_BASELINE_SNAP,
	PEAK_PICK_VAR_ID_BASELINE_N_POINTS,
	PEAK_PICK_VAR_ID_BASELINE_CONNECT,

	//PEAK_PICK_VAR_ID_POSITIVE,
	//PEAK_PICK_VAR_ID_NEGATIVE,
	PEAK_PICK_VAR_ID_DIRECTION,

	PEAK_PICK_VAR_ID_METHOD,
	PEAK_PICK_VAR_ID_LOCAL_POINTS,
	PEAK_PICK_VAR_ID_SIZE_OPTION,
	PEAK_PICK_VAR_ID_HEIGHT,
	PEAK_PICK_VAR_ID_WIDTH,

	PEAK_PICK_VAR_ID_FIRST,
	PEAK_PICK_VAR_ID_SECOND,
	PEAK_PICK_VAR_ID_FFT_CUTOFF,
	PEAK_PICK_VAR_ID_DERIV_POLY,
	PEAK_PICK_VAR_ID_DERIV_NPTS,

	PEAK_PICK_VAR_ID_FILTER,
	//PEAK_PICK_VAR_ID_VALUE,
	PEAK_PICK_VAR_ID_VAL_HEIGHT,
	PEAK_PICK_VAR_ID_VAL_NUM,

	PEAK_PICK_VAR_ID_OUTPUT,

	PEAK_PICK_VAR_ID_LEFT_X,
	PEAK_PICK_VAR_ID_RIGHT_X,
	PEAK_PICK_VAR_ID_FIXSCALE,

	PEAK_PICK_VAR_ID_TOOL_NAME,
	PEAK_PICK_VAR_ID_RECT_COLOR,
	
	PEAK_PICK_VAR_ID_SHOW_LABEL,
	PEAK_PICK_VAR_ID_CENTER_LABEL,
	PEAK_PICK_VAR_ID_ROLATE_LABEL,
	PEAK_PICK_VAR_ID_LABEL_COLOR,
};

enum
{
	PEAK_BASELINE_MODE_NONE,
	PEAK_BASELINE_MODE_USE_EXISTING_DATASET,
	PEAK_BASELINE_MODE_CONSTANT,
	PEAK_BASELINE_MODE_AUTO,
};

enum
{
	PEAK_BASELINE_CREATION_GLOBAL,
	PEAK_BASELINE_CREATION_SEPARATE,
};

enum
{
	PEAK_BASELINE_CONST_MIN,
	PEAK_BASELINE_CONST_MAX,
	PEAK_BASELINE_CONST_MEAN,
	PEAK_BASELINE_CONST_MEDIAN,
	PEAK_BASELINE_CONST_CUSTOM,
};

enum
{
	PEAK_BASELINE_CONNECT_METHOD_LINE,
	PEAK_BASELINE_CONNECT_METHOD_SPLINE,
	PEAK_BASELINE_CONNECT_METHOD_BSPLINE,
};

enum
{
	PEAK_DIRECTION_POSITIVE,
	PEAK_DIRECTION_NEGATIVE,
	PEAK_DIRECTION_BOTH
};

enum
{
	PEAK_FINDING_METHOD_MAX,
	PEAK_FINDING_METHOD_WIN,
	PEAK_FINDING_METHOD_FIRST,
	PEAK_FINDING_METHOD_SECOND,
	PEAK_FINDING_METHOD_RESIDUE,
};

enum
{
	SIZE_OPTION_RAW_SIZE,
	SIZE_OPTION_PERCENT_OF_RAW_DATA,
};

enum
{
	PEAK_FILTER_NONE,
	PEAK_FILTER_HEIGHT,
	PEAK_FILTER_NUM,
};

enum
{
	PEAK_CENTER_LABEL_X,
	PEAK_CENTER_LABEL_Y,
	//PEAK_CENTER_LABEL_INDICES,
	PEAK_CENTER_LABEL_XY,
};

struct BaselineInfo
{
	int		m_nMode;

	string	m_strRefer;

	int		m_nConstant;
	double	m_dCustom;

	int		m_nAnchor;
	bool	m_bSnap;
	int		m_nConnect;
};

bool	baseline_creation_multi_sel_attrib_access(TreeNode& trBaseline, bool bGet = true, bool bMultiSel = false);

void	construct_pick_peak_gui(TreeNode& trGUI);

int		open_pick_peak_tool(TreeNode& trGUI);

bool	check_update_roi_x_position(TreeNode& trXScale);

#endif // _PICK_PEAK_H__
